/**************************************************************************//**
 *	\file	adc_Cfg.h
 *
 *	\brief	This file provides all the configurations provided by ADC module 
 *			of Freescale MPC563 power-pc MCU
 *
 *	\version	1.0A - Initial Draft
 *	\date		25 June 2010
 *
 *	\version	1.1A - Design changed to support run-time CCW addition and 
 *						configuration
 *	\date		16 July 2010
 *****************************************************************************/
#ifndef ADC_CFG_H 
#define ADC_CFG_H 
/******************************************************************************
Include Files
******************************************************************************/

/******************************************************************************
Type defines
******************************************************************************/


/**	\brief	This macro defines the total no.of CCWs available in 
			each ADC converter module */
#define ADC_TOT_CCW	64

/**	\brief	This defines the address for the ADC converter module A register 
			group */
#define QADC_MOD_A   (( struct QADC64_tag *) (INTERNAL_MEMORY_BASE + 0x304800))
/**	\brief	This defines the address for the ADC converter module B register 
			group */
#define QADC_MOD_B   (( struct QADC64_tag *) (INTERNAL_MEMORY_BASE + 0x304C00))

#endif